//Disco FloorMod01.fsh
//https://www.shadertoy.com/view/MtyyDy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
// Use defines here rather than edit the body of the code.

#define iTime u_Elapsed*0.314159
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////
uniform sampler2D iChannel0;
#define PI 3.14159

#ifdef GL_ES
precision lowp float;
#endif










mat2 rot(float a){
    return mat2(cos(a), -sin(a),
                sin(a), cos(a));
}

float sphere(vec3 p, float radius){
    return length(p)-radius;
}

float map(vec3 p)
{
    float radius = 0.25; // or change to 0.1 for carpet like look
    vec3 q = fract(p*=2.5) * 1.5 - 0.5;
    
    return sphere(q, radius);
}

float trace(vec3 origin, vec3 r) 
{
  float t = 0.2;
    for (int i = 0; i < 100; ++i) {
        vec3 p = origin + r * t;
        float d = map(p);
        t += d * 0.1;
        }
    return t;
}
void main( void )
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    
    uv = uv *3.-2.; 
    uv.x *= iResolution.y/iResolution.x;
    
    vec3 color = vec3((sin(iTime)), 4.0, 1.1);
    
   	float FOV = 1.5;
   	vec3 ray = normalize(vec3(uv, FOV));
    
    // Rotate Y towards Z
    ray.xy *= rot(iTime*0.2);
    ///ray.zx *= rot(iTime*0.1);
    
    vec3 origin = vec3(0.5, 0.75, 1.0);
    float t = trace(origin, ray);
    
    float expFog = 10. / (t*t*0.1);
    
    vec3 fc = vec3(expFog);

    
    gl_FragColor = vec4(cos(fc+color),5.0);
    

}

